  library("rjson")
  library("rstudioapi")
  library("ggpubr")
  library("tidyverse")
  
  current_path = rstudioapi::getActiveDocumentContext()$path 
  setwd(dirname(current_path))
  files <- list.files("./pressure")
  
  frame <- data.frame(name=c(), eps=c(), value=c(), value_rp=c(), time=c(), algorithm=c(),
                      dimensions=c(), points=c(), searches_s=c(),
                      searches_p=c(), searches_s_rp=c(), searches_p_rp=c(), newdim=c())
  
  for (file in files) {
    print(file)
    json_data <- fromJSON(file=paste(getwd(), "/pressure/", file, sep=""))
    json_data_frame <- as.data.frame(json_data)
    method <- json_data_frame[1, "data.method"]
    datanames <- paste(json_data_frame[1, "data.names"], "/",substr(json_data_frame[2, "data.names"], 3, 3), sep="")
    eps <- json_data_frame[1, "data.epsilon"]
    number_points <- c(json_data_frame[1, "data.lengths"], json_data_frame[2, "data.lengths"])
    number_dimensions <- c(json_data_frame[1, "data.dimensions"], json_data_frame[2, "data.dimensions"])
    values <- list(json_data_frame[1, "sequential.without_rp.value"], 
                   json_data_frame[1, "sequential.with_rp.value"])
    times_searches <- list(json_data_frame[1, "sequential.without_rp.rt_s"],
                           json_data_frame[1, "sequential.with_rp.rt_s"],
                           json_data_frame[1, "parallel.without_rp.rt_s"],
                           json_data_frame[1, "parallel.with_rp.rt_s"])
    times_bounds <- list(json_data_frame[1, "sequential.without_rp.rt_b"],
                         json_data_frame[1, "sequential.with_rp.rt_b"],
                         json_data_frame[1, "parallel.without_rp.rt_b"],
                         json_data_frame[1, "parallel.with_rp.rt_b"])
    number_searches <- list(json_data_frame[1, "sequential.without_rp.n_s"],
                            json_data_frame[1, "sequential.with_rp.n_s"],
                            json_data_frame[1, "parallel.without_rp.n_s"],
                            json_data_frame[1, "parallel.with_rp.n_s"])
    newdim <- ceiling(2 * 1/(eps*eps) * log(number_points[[1]]+number_points[[2]]))
    data <- list(datanames, values, times_searches, number_searches, times_bounds, eps)
    key <- paste(datanames, eps)
    print(paste("found data:", key))
    frame <- rbind(frame, data.frame(name=datanames, eps=0, value=values[[1]],
                                     value_rp=values[[2]], time_s=times_searches[[1]]/60,
                                     time_b=times_bounds[[1]]/60,
                                     searches=number_searches[[1]],
                                     algorithm="sequential",
                                     dimensions=number_dimensions,
                                     points=number_points, newdim=number_dimensions[[1]]))
    frame <- rbind(frame, data.frame(name=datanames, eps=eps, value=values[[1]],
                                     value_rp=values[[2]], time_s=times_searches[[2]]/60,
                                     time_b=times_bounds[[2]]/60,
                                     searches=number_searches[[2]],
                                     algorithm="sequential_rp",
                                     dimensions=number_dimensions,
                                     points=number_points, newdim=newdim))
    frame <- rbind(frame, data.frame(name=datanames, eps=0, value=values[[1]],
                                     value_rp=values[[2]], time_s=times_searches[[3]]/60,
                                     time_b=times_bounds[[3]]/60,
                                     searches=number_searches[[3]],
                                     algorithm="parallel",
                                     dimensions=number_dimensions,
                                     points=number_points, newdim=number_dimensions[[1]]))
    frame <- rbind(frame, data.frame(name=datanames, eps=eps, value=values[[1]],
                                     value_rp=values[[2]], time_s=times_searches[[4]]/60,
                                     time_b=times_bounds[[4]]/60,
                                     searches=number_searches[[4]],
                                     algorithm="parallel_rp",
                                     dimensions=number_dimensions,
                                     points=number_points, newdim=newdim))
  }
  
  files <- list.files("./simplex")
  cc <- 0
  for (file in files) {
    json_data <- fromJSON(file=paste(getwd(), "/simplex/", file, sep=""))
    json_data_frame <- as.data.frame(json_data)
    
    method <- json_data_frame[1, "data.method"]
    if (method == "jl") {
      datanames <- paste(json_data_frame[1, "data.names"], json_data_frame[2, "data.names"])
      eps <- json_data_frame[1, "data.epsilon"]
      methodtime <- json_data_frame[1, "data.methodtime"]
      method <- json_data_frame[1, "data.method"]
      number_points <- c(json_data_frame[1, "data.lengths"], json_data_frame[2, "data.lengths"])
      number_dimensions <- c(json_data_frame[1, "data.dimensions"], json_data_frame[2, "data.dimensions"])
      values <- list(json_data_frame[1, "rp.value"],
                     json_data_frame[1, "nrp.value"])
      times_searches <- list(json_data_frame[1, "rp.rt_s"],
                             json_data_frame[1, "nrp.rt_s"])
      times_bounds <- list(json_data_frame[1, "rp.rt_b"],
                           json_data_frame[1, "nrp.rt_b"])
      number_searches <- list(json_data_frame[1, "rp.n_s"],
                              json_data_frame[1, "nrp.n_s"])
      newdim <- ceiling(2 * 1/(eps*eps) * log(number_points[[1]]+number_points[[2]]))
      #data <- list(datanames, values, times_searches, number_searches, times_bounds, eps)
      key <- paste(datanames, eps)
      print(paste("found data:", key))
      #frame <- rbind(frame, data.frame(name=datanames, eps=0, value=values[[1]],
      #                                 value_rp=values[[2]], time_s=times_searches[[1]]/60,
      #                                 time_b=times_bounds[[1]]/60,
      #                                 searches=number_searches[[1]],
      #                                 algo="parallel",
      #                                 dimensions=number_dimensions,
      #                                 points=number_points, newdim=number_dimensions[[1]]))
      frame <- rbind(frame, data.frame(name="rand. simpl.", eps=eps, value=values[[2]],
                 value_rp=values[[1]], time_s=times_searches[[2]]/60,
                 time_b=times_bounds[[2]]/60,
                 searches=number_searches[[2]],
                 algorithm="parallel_rp",
                 dimensions=number_dimensions,
                 points=number_points, newdim=newdim))
      cc <- cc + 1
    }
  }
  
  data <- frame %>%
    group_by_at(vars(name, eps, newdim)) %>%
    mutate(time = time_s + time_b) %>%
    mutate(deviation = abs(1 - value_rp / value)) %>%
    mutate(epsilon=paste(eps, " (", newdim, ")", sep="")) %>%
    filter(eps == 0 | eps >= 0.25)
  
  data2 <- data %>% filter(epsilon >= 0.25) %>% mutate(data=name)
  
  data3 <- data #%>% filter(name != "random simplex")
  
  ggplot(data3, aes(factor(epsilon), time/60)) +
    scale_x_discrete(name = "input epsilon (corr. #dimensions)") +
    scale_y_continuous(trans = "log10", name = "running-time [h]") +
    theme(legend.position = c(0.81, 0.8),
          legend.direction = "vertical", 
          legend.background = element_rect(fill=alpha('blue', 0.0))) +
    geom_boxplot(aes(color = algorithm), outlier.alpha = 0.5) +
    theme(text = element_text(size=20))+ annotation_logticks(sides="l")  
  
  ggplot(data2, aes(factor(epsilon), deviation)) + 
    geom_boxplot(aes(color = data), outlier.alpha=0.5) +
    scale_color_discrete(name="") +
    scale_x_discrete(name = "input epsilon (corr. #dimensions)") +
    scale_y_continuous(name = "empirical relative error") +
    theme(legend.position = c(0.325, 0.875), 
          legend.background = element_rect(fill=alpha('blue', 0.0)),
    legend.direction = "horizontal") + theme(text = element_text(size=20))
