  library("rjson")
  library("rstudioapi")
  library("ggpubr")
  library("tidyverse")
  
  current_path = rstudioapi::getActiveDocumentContext()$path 
  setwd(dirname(current_path))
  files <- list.files("./onemed_ghg")
  
  frame <- data.frame(epsilon1=c(), epsilon2=c(), value=c(), method=c(), time=c(), algorithm=c(),
                      dimensions=c(), points=c(), centers=c(), assignment=c(), newdim=c())
  
  c <- 0
  acc <- 0
  
  for (file in files) {
    print(file)
    json_data <- fromJSON(file=paste(getwd(), "/onemed_ghg/", file, sep=""))
    
    method <- json_data$method
    epsilon1 <- json_data$data$epsilon1
    epsilon2 <- json_data$data$epsilon2
    number_points <- json_data$data$lengths
    number_dimensions <- json_data$data$dimension
    values <- list(json_data$without_rp$value, 
                   json_data$with_rp$value)
    times <- list(json_data$without_rp$`running-time`, json_data$with_rp$`running-time`)
    centers <- list(json_data$without_rp$centers, json_data$with_rp$centers)
    if (epsilon1 == 0) {
      newdim = number_dimensions
    } else {
      newdim <- 2 * ceiling(1/(epsilon1*epsilon1) * log(43830))
    }
    c <- c + 1
    # if (k == 5) {
    #   print(assignments[[1]])
    # }
    # data <- list(datanames, values, times_searches, number_searches, times_bounds, epsilon)
    # key <- paste(datanames, epsilon)
    # print(paste("found data:", key))
    frame <- rbind(frame, data.frame(epsilon1=0, epsilon2=epsilon2, value=values[[1]],
                                     time=times[[1]]/60,
                                     algorithm="parallel",
                                     dimensions=number_dimensions,
                                     points=number_points,
                                     method=method,newdim=number_dimensions))
    frame <- rbind(frame, data.frame(epsilon1=epsilon1, epsilon2=epsilon2, value=values[[2]],
                                     time=times[[2]]/60,
                                     algorithm="parallel_rp",
                                     dimensions=number_dimensions,
                                     points=number_points,
                                     method=method,newdim=newdim))
  }
  
  data <- frame %>%
    group_by_at(vars(epsilon1, epsilon2, method, algorithm)) %>%
    mutate(parameters = paste(epsilon1, epsilon2, sep=", ")) %>%
    mutate(epsilon_rp = paste(epsilon1, " (", newdim, ")", sep=""))
  
  data_a_worp <- data %>%
    filter(method=="approx") %>%
    filter(algorithm=="parallel") %>%
    mutate(sampling="subsampling alone")
  
  data_a_wrp <- data %>%
    filter(method=="approx") %>%
    filter(algorithm=="parallel_rp") %>%
    mutate(sampling="subsampling with rp")
  
  data_wrp <- data %>%
    filter(method=="exact_wrp") %>%
    mutate(sampling="none with rp")
  
  data_worp <- data %>%
    filter(method=="exact_worp") %>%
    mutate(sampling="none")
  
  data_ber2 <- rbind(data_a_worp, data_a_wrp, data_worp, data_a_wrp)
  
  data_ber3 <- data_ber2 %>% filter(epsilon2 > 0)
  
  ggplot(data_ber2, aes(factor(epsilon2), time/60)) +  
    scale_x_discrete(name = "epsilon sampling") +
    scale_y_log10(name = "running-time [h]") +
    geom_boxplot(aes(color = epsilon_rp), outlier.alpha = 0.5) +
    scale_color_discrete(name="epsilon rp (corr. #dim)") +
    theme(text = element_text(size=20))+ annotation_logticks(sides="l") +
    theme(legend.position = c(0.8, 0.8), legend.direction = "vertical", 
          legend.background = element_rect(fill=alpha('blue', 0.0)))
  
  ggplot(data_ber3, aes(factor(epsilon2), abs(value/data_worp[["value"]][[1]]-1)*100)) + 
    geom_boxplot(aes(color=epsilon_rp), outlier.alpha = 0.5, show.legend = F) + 
    scale_x_discrete(name = "epsilon sampling") +   
    scale_y_continuous(name = "deviation [%]", limits=c(0, 12.5)) +
    theme(text = element_text(size=20))