import calc_frechet
import numpy as np
import pandas as pd
import sys
import json
import time
from sklearn import random_projection

if len(sys.argv) < 4:
	dat1 = "PS1"
	dat2 = "PS2"
	epsilon = 0.4
	
else:
	dat1 = sys.argv[1]
	dat2 = sys.argv[2]
	epsilon = float(sys.argv[3])

if epsilon == 0.25:
    k = 1290
elif epsilon == 0.5:
    k = 404
elif epsilon == 0.75:
    k = 240

def import_from_txt(path):
    data = pd.read_csv(path, sep="\t", header=None)
    return data

#Import the data


name1 = "../data/{}.txt".format(dat1)
name2 = "../data/{}.txt".format(dat2)

data1 = import_from_txt(name1)
data2 = import_from_txt(name2)

data_np_array1 = data1.values
data_np_array2 = data2.values
data_np_array1 = np.array(data_np_array1, dtype="d")
data_np_array2 = np.array(data_np_array2, dtype="d")

l = len(data_np_array1)

start = time.clock()

transformer = random_projection.SparseRandomProjection(n_components=k)
data = transformer.fit_transform(np.concatenate((data_np_array1, data_np_array2)))

end = time.clock()

d1_pca = calc_frechet.Curve(data[:l])
d2_pca = calc_frechet.Curve(data[l:])

distance = calc_frechet.calculate_distance_parallel(d1_pca, d2_pca)

dump = {
	'data': {
        'method': 'jl',
        'methodtime': end-start,
		'names': [dat1, dat2],
		'lengths': [data[:l].shape[0], data[l:].shape[0]],
		'dimensions': [data[:l].shape[1], data[l:].shape[1]],
		'epsilon': epsilon,
	},
	'rp': {
			'rt_b': distance.time_bounds,
			'rt_s': distance.time_searches,
			'n_s': distance.number_searches,
			'value': distance.value,
    },
}

print(json.dumps(dump))
