import calc_frechet
import numpy as np
import pandas as pd
import sys
import os
import json

if len(sys.argv) < 3:
	epsilon = 0.75
	k = 2
else:
	k = int(sys.argv[2])
	epsilon = float(sys.argv[1])

def import_from_txt(path):
    data = pd.read_csv(path, sep=" ", header=None)
    return data

#Import the data

files = os.listdir("../data/ghg_data")

T = calc_frechet.Curves()

for f in files:
	data = import_from_txt("../data/ghg_data/{}".format(f))
	data_np = np.array(data.values, dtype="d")
	t = calc_frechet.Curve(data_np)
	T.add(t)
	
T_rp = calc_frechet.jl_transform(T, epsilon)

result = calc_frechet.kcenter(k, T)
result_rp = calc_frechet.kcenter(k, T_rp)

dump = {
	'data': {
		'name': "ghg_data",
		'lengths': T[0].points,
		'dimension': T[0].dimensions,
		'epsilon': epsilon,
		'k': k,
	},
	'without_rp': { 
		'value': result.value,
		'centers': [result[i] for i in range(0, k)],
		'running-time': result.running_time,
		},
	'with_rp': { 
		'value': result_rp.value,
		'centers': [result_rp[i] for i in range(0, k)],
		'running-time': result_rp.running_time,
		},
}

print(json.dumps(dump))
