import calc_frechet
import numpy as np
import pandas as pd
import sys
import os
import json

if len(sys.argv) < 3:
	epsilon1 = 0.75
	epsilon2 = 0.75
else:
	epsilon2 = float(sys.argv[2])
	epsilon1 = float(sys.argv[1])

def import_from_txt(path):
    data = pd.read_csv(path, sep=",")
    return data

#Import the data

files = os.listdir("../data/DELTA")

T = calc_frechet.Curves()

for f in files:
	data = import_from_txt("../data/DELTA/{}".format(f))
	data_np = np.array(data.values[:,2:], dtype="d")
	t = calc_frechet.Curve(data_np)
	T.add(t)
	
T_rp = calc_frechet.jl_transform(T, epsilon1)

result_a = calc_frechet.onemedian_approx(epsilon2, T)
result_a_rp = calc_frechet.onemedian_approx(epsilon2, T_rp)

dump = {
	'method': 'approx',
	'data': {
		'name': "ghg_data",
		'lengths': T[0].points,
		'dimension': T[0].dimensions,
		'epsilon1': epsilon1,
		'epsilon2': epsilon2,
	},
	'without_rp': { 
		'value': result_a.value,
		'centers': result_a[0],
		'running-time': result_a.running_time,
	},
	'with_rp': { 
		'value': result_a_rp.value,
		'centers': result_a_rp[0],
		'running-time': result_a_rp.running_time,
	},
}

print(json.dumps(dump))
