% Demo Code NIPS paper 818
clear;clc;close all;
% you should install matconvnet first: http://www.vlfeat.org/matconvnet/
% run(fullfile('matconvnet','matlab','vl_setupnn.m'));
opts.dataDir = pwd; % data path
imdbfile = fullfile(opts.dataDir,'imdb.mat');
if ~exist(imdbfile,'file')
    imdb = getMnistImdb(opts); % MNIST dataset
    save(imdbfile,'-struct','imdb');
else
    imdb = load(imdbfile);
end
%%
load Versatile_LeNet3.mat; % The accuracy of the original network is 99.20%
net.layers{end}.type = 'softmax';
%% display size of conv filters
layernum = length(net.layers);
ind = 0;
for i = 1:layernum
    if strcmp(net.layers{i}.type,'VConv')
        ind = ind+1;
        fprintf('Filter size of convolutional layer %d is :\n',ind);
        disp(size(net.layers{i}.weights{1}));
    end
end
%% evaluating
test_ind = find(imdb.images.set == 3);
res = vl_simplenn(net,imdb.images.data(:,:,1,test_ind));
[~,cl] = max(squeeze(res(end).x));
correct = sum(cl==imdb.images.labels(test_ind))/length(test_ind);
fprintf('The classification accuracy on MNIST is %.2f%%.\n',correct*100);