import lom
import numpy as np
import pandas as pd
import sys, getopt


def from_file(csv_file, outfile, clusterOutputFile, K, lbda):
	data = 2*np.array(pd.read_csv(csv_file, header=None), dtype=np.int8)-1
	data *= -1 # invert

	L = K

	orm = lom.Machine()

	data = orm.add_matrix(data, fixed=True)
	layer = orm.add_layer(latent_size=L, child=data, model='OR-AND')
	layer.lbda.val = lbda

	orm.infer(burn_in_min=300, burn_in_max=1000, fix_lbda_iters=100, no_samples=50)

	results = 1 - layer.u.mean().transpose()
	np.savetxt(outfile, results, delimiter=',')
	np.savetxt(clusterOutputFile, layer.z.mean().transpose(), delimiter=',')

def main(argv):
	K = 1
	lbda = 0.5

	try:
		opts, args = getopt.getopt(argv,"k:i:o:",["lambda=","clusterOutputFile="])
	except getopt.GetoptError:
		printHelp()
		sys.exit(2)
	for opt, arg in opts:
		if opt  == "-i":
			inputfile = arg
		elif opt == "-o":
			outputfile = arg
		elif opt == "--clusterOutputFile":
			clusterOutputFile = arg
		elif opt == "-k":
			K = int(arg)
		elif opt == "--lambda":
			lbda = float(arg)
		else:
			print("unknown option {0}".format(opt))
			sys.exit()

	from_file(inputfile, outputfile, clusterOutputFile, K, lbda)

if __name__ == "__main__":
	main(sys.argv[1:])
