library(tidyverse)

visualize_predictions <- function(frame, samples) {
  frame <- filter(frame, sample_num %in% samples)
  frame <- mutate(frame, observed = as.logical(observed))
  ggplot(frame) +
    geom_point(aes(t, y, color = observed)) +
    geom_point(aes(t, y_hat), color = "black") +
    facet_wrap(~ sample_num)
}

base1 <- read_csv("prediction_output/base_predictions1.csv")
prop1 <- read_csv("prediction_output/prop_predictions1.csv")

base2 <- read_csv("prediction_output/base_predictions2.csv")
prop2 <- read_csv("prediction_output/prop_predictions2.csv")

base3 <- read_csv("prediction_output/base_predictions3.csv")
prop3 <- read_csv("prediction_output/prop_predictions3.csv")

