clear;
close all;

% Constants from experiments
H = 50;
NC = 50;
SC = 10;
Spec = 25;
TI = 25;
N = 15;
x = [0.1, 0.5:0.5:25]; % epsilon
Seed = 0:20;

% Collect results
y = [];
dev = [];
for epsilon = x
  [ cost, F, G ] = aggregate_real(H, NC, SC, Spec, TI, epsilon, N, Seed);
  dev = [dev mean(true_epsilon(N, F, G))];
  y = [y mean(cost)];
end

% Plot Cost
f = figure('Position', [100, 100, 300, 200]);
plot(x, y);
title(['Cost vs \epsilon']);
xlabel('\epsilon');
ylabel('Cost');
xlim([min(x) max(x)]);
save2pdf(['cost.pdf']);

% Plot Deviation
f = figure('Position', [100, 100, 300, 200]);
plot(x, dev);
title(['Deviation vs \epsilon']);
xlabel('\epsilon');
ylabel('Deviation');
xlim([min(x) max(x)]);
save2pdf(['deviation.pdf']);

