# BACKSHIFT: Learning causal cyclic graphs from unknown shift interventions

The attached R code runs BACKSHIFT, an algorithm to estimate the connectivity 
matrix of a directed (possibly cyclic) graph with hidden variables. The 
underlying system is required to be linear and we assume that observations 
under different shift interventions are available.


## Installation

### BACKSHIFT package
To install BACKSHIFT from CRAN run: 

```
install.packages("backShift")
```

This command will also install the following dependencies: "jointDiag", 
"clue", "gmp", "pcalg", "igraph", "matrixcalc" and "reshape2" (from CRAN) as
well as "graph" and "RBGL" (from bioconductor).


## Examples

### Example 1
For a short example, run the following commands in R: 
```
require(backShift)
example(backShift)
```

### Reproduce Figure 2 from the paper
The code in `reproduceExperiments.R` allows you to reproduce the simulations 
shown in the paper. The adjacency matrix can be loaded with 
`data("exampleAdjacencyMatrix")`. Otherwise, you can also provide an adjacency matrix 
yourself or generate one.

NOTE: The naming of the objects in the code is not always consistent with the naming in the paper. 
In the code, the entry A_ij in the adjacency matrix A contains the edge from node i to node j. 
A thus corresponds to the transpose of the matrix B, referred to in the paper. 
Also, the order in which the nodes are plotted differs slightly.