#ifndef HEADER_LOG
#define HEADER_LOG

#include <iostream>
#include <sstream>
#include <vector>
#include <cstdio>
#include <sstream>
#include <fstream>
#include <string>
#include <cerrno>
/* yuck, no C++ versions? */
#include <fcntl.h>
#include <unistd.h>


class LogEntry {
  public:
  int id;
  double x;
  double y;
  LogEntry(int idc, double xc, double yc) : id(idc), x(xc), y(yc) {
  }
  LogEntry() {
  }
};

template<class T> class Logger {
  public:

  std::vector<T> data;
  std::string filename;

  Logger(std::string fn) {
    filename = fn;
  }

  void give_lock() {
    remove(".lock");
  }

  void get_lock() {
    int fd = open(".lock", O_WRONLY | O_CREAT | O_EXCL, S_IRWXU);
    while (fd < 0) {
      perror("something went wrong:");
      sleep(1);
      std::cout << "sleeping on lock\n";
      fd = open(".lock", O_WRONLY | O_CREAT | O_EXCL, S_IRWXU);
    }
    close(fd);
  }

  void log(T entry) {
    data.push_back(entry);
  }

  void save() {
    get_lock();
    std::ofstream out(filename, std::ios::app);
    for (auto &e : data) {
      out.write((char*)&e, sizeof(T));
    }
    out.close();
    give_lock();
    data.clear();
  }

};


#endif
