
set.seed(0)

c1 <- read.table("c1.txt")$V1[ 1 ]
c2 <- read.table("c2.txt")$V1[ 1 ]

x1 <- as.matrix(read.table(paste("../../data_AwA/", c1,".surf", sep = "")))
x2 <- as.matrix(read.table(paste("../../data_AwA/", c2,".surf", sep = "")))

x <- rbind(x1, x2)

#x <- t(apply(x, 1, function(x) x / sum(abs(x))))

xstar1 <- as.matrix(read.table(paste("../../data_AwA/", c1,".DAP", sep = "")))
xstar2 <- as.matrix(read.table(paste("../../data_AwA/", c2,".DAP", sep = "")))

xstar <- rbind(xstar1, xstar2)

# We add the noise

labels <- c(rep(1, nrow(x1)), rep(-1, nrow(x2)))

data <- list()
data$x <- x
data$x_star <- xstar
data$y_train <- NULL
data$y_test <- NULL
data$itrain <- NULL
data$ival <- NULL
data$itest <- NULL
data$is_different <- NULL

for (i in 1 : 100) {

	print(i)

	sel_tr1 <- sample(1 : nrow(x1), 100)
	sel_tr2 <- sample(1 : nrow(x2), 100) + nrow(x1)

	n_test <- min(nrow(x1) - 200, nrow(x2) - 200)

	sel_val1 <- sample((1 : nrow(x1))[ -c(sel_tr1) ], 100)
	sel_val2 <- sample((1 : nrow(x2))[ -c(sel_tr2 - nrow(x1)) ], 100) + nrow(x1)
	sel_test1 <- sample((1 : nrow(x1))[ -c(sel_tr1, sel_val1) ], n_test)
	sel_test2 <- sample((1 : nrow(x2))[ -c(sel_tr2 - nrow(x1), sel_val2 - nrow(x1)) ], n_test) + nrow(x1)

	sel_train <- c(sel_tr1, sel_tr2)
	sel_val <- c(sel_val1, sel_val2)
	sel_test <- c(sel_test1, sel_test2)

	data$itrain <- rbind(data$itrain, sel_train)
	data$itest <- rbind(data$itest,  sel_test)
	data$ival <- rbind(data$ival,  sel_val)
	data$y_train <- rbind(data$y_train, labels[  sel_train ])
	data$y_test <- rbind(data$y_test, labels[  sel_test ])
	data$y_val <- rbind(data$y_val, labels[  sel_val ])
	
	s <- sample(1 : 200)

	data$itrain[ i, ] <- data$itrain[ i, s ]
	data$y_train[ i, ] <- data$y_train[ i, s ]
}

#for (i in 1 : 100) {
#
#	is_different <- sample(1 : 200, 40)
#	data$y_train[ i, is_different ] <- data$y_train[ i, is_different ] * -1
#
#	value <- rep(0, 200)
#	value[ is_different ] <- 1
#	data$is_different <- rbind(data$is_different, value)
#}

save(data, file = paste("data.dat", sep = ""))

