function thetas = sample_parameters(theta_space, delta, K)
% thetas = sample_parameters(theta_space, delta, K)
%
% Samples K parameters (theta) from the parameter space Theta
%  where Theta is defined as the set of all points within a hypercube of edge length
%  2* delta of a column vector in theta_space
%
% Inputs
%  - theta_space, D x K0 matrix: columns of theta_space form a grid over the parameter space
%  - delta, scalar: normally the minimum spacing between points in theta_space
%  - K, positive integer: number of points to sample 
%
% Outputs
%  - thetas: D x K matrix: columns are randomly sampled parameters
% 
% Example usage:
%  theta_space = .5 .* (fullfact([5 5])-3)'; % grid on [-1,1]^2
%  delta = .5;
%  thetas = sample_thetas(theta_space,delta,10); % will sample points from [-1.25,1.25]^2

D = size(theta_space,1);
K0 = size(theta_space,2);
thetas = theta_space(:,randsample(K0,K,true)) + delta.*(rand(D,K)-.5);
end
