function [centers,delta] = sphlattice( main_reso,rad )
% [centers,delta] = sphlattice( main_reso,rad )
%  Generates a grid inside the 3 dimensional sphere of radius rad
% 
% Input:
%  - main_reso, positive integer: controls the spacing of the grid
%  - rad, scalar: radius of the sphere
% 
% Outputs:
%  - centers, 3x? matrix of grid points inside sphere
%  - delta, minimal spacing of grid
tempgrid2 = (-main_reso:main_reso)./main_reso;
delta = rad*.5/main_reso;
nreso2=size(tempgrid2,2);
sphere_lattice = [kron(tempgrid2',ones(nreso2^2,1)),kron(ones(nreso2,1),kron(tempgrid2',ones(nreso2,1))),kron(ones(nreso2^2,1),tempgrid2')]';

nms = sqrt(sum(sphere_lattice.^2));
filtt = (nms <= 1) & (sphere_lattice(3,:) >=0) ;
centers = rad.*sphere_lattice(:,filtt);

end

