function [y,y0] = generate_data( v,w,grid,noise )
% generate_data( v,w,grid,noise )
%  Generates synthetic voxel given noise level
% 
% Inputs:
%  - v, 3xK matrix of diffusivity (kappa)-weighted vectors
%  - w, Kx1: weights
%  - grid, 3xn: measurement directions (should be unit vectors)
%  - noise: sigma parameter for Rice distribution
%
% Outputs:
%  - y, nx1: signal with Rician noise
%  - y0, nx1: noiseless signal
xs=ste_tan0(v,grid);
y0=xs * w;
n = size(grid,2);
temp=noise * randn(n,2);
temp(:,1) = temp(:,1)+y0;
temp = temp.^2;
temp = sum(temp')';
y=sqrt(temp);  
end

