function [X, D_guess, parameters ] = L1cvx(Y,G, opt)
%This function uses the cvx toolbox for solving the L1 minimization
%approach to solve the calibration problem
try
    cvx_setup;
catch err
    disp('cvx package seems not to be installed!');
    return;
end

[m P] = size(Y);
[m N] = size(G);
d = opt.d;


%% Solver
cvx_begin
    variable x(N,P)
    variable M(m)
    minimize( norm(x(:),1) )
        subject to
        diag( M )*Y==G*x;
        sum(M)==d*m;
cvx_end
    
%% Results    
D_guess = M;
X = x;
parameters.iterations = cvx_slvitr;

end
