function result = Int(N,mu,sigma,a,b)
%this function gives an analytical estimate of the integral
% int_a^b |x|^N exp(-(x-mu)^2/sigma)
% using incomplete gamma functions

result = 0;

for i=0:N
    
    if rem(i,2)==0
        incr = 1/2.*gamma(i/2+1/2).*(sign(b-mu).*gammainc((b-mu).^2./(2*sigma),i/2+1/2) - sign(a-mu).*gammainc((a-mu).^2./(2*sigma),i/2+1/2));
    else
        incr = 1/2.*gamma(i/2+1/2).*(gammainc((b-mu).^2./(2*sigma),i/2+1/2) - gammainc((a-mu).^2./(2*sigma),i/2+1/2));
    end;
    
    result = result + nchoosek(N,i).*mu.^(N-i).*(sqrt(2*sigma)).^(i+1).*incr;
    
end


end
