function [f,g,d] = dual_kl_obj(y, Phi, Phin, p_hat, idx)

% reshape and partition y
k = size(Phi,2);
p = numel(y) / (2*k);
y0 = reshape(y, 2*k, p);
y1 = y0(1:k,:); y2 = y0(k+1:end,:);

% compute c terms
Phi_y1 = Phi*y1;
Phi_y2 = Phi*y2;
Phin_y2 = Phin*y2;
c = -sum(Phi_y1.^2,2) - 2*sum(Phi_y1.*Phin_y2,2) - sum(Phi_y2.^2,2);

% if there is an idx input, group states together
m0 = max(idx);
if (m0 < size(Phi,1))
  c0 = zeros(m0,1); p0 = zeros(m0,1); b0 = zeros(m0,1);
  for i=1:m0, c0(i) = sum(c(idx == i)); end
  for i=1:m0, p0(i) = sum(p_hat(idx == i)); end
  for i=1:m0, b0(i) = sum((idx == i)); end
else
  c0 = c;
  p0 = p_hat;
  b0 = ones(size(c,1),1);
end
    
% optimize kl divergence and compute function and gradient values
d0 = optimize_kl(p0, c0, b0);
f = sum(p0.*log(d0)) - c0'*d0;
if (m0 < size(Phi,1))
  d = zeros(size(Phi,1),1);
  for i=1:m0, d(idx == i) = d0(i); end
else
  d = d0;
end

% compute and resize gradient
g = 2*[Phi'*((Phi_y1 + Phin_y2).*repmat(d,1,p));
  Phin'*(Phi_y1.*repmat(d,1,p)) + Phi'*(Phi_y2.*repmat(d,1,p))];
g = reshape(g, size(y,1), size(y,2));


