%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% parent_entry:
%
% Customized conversion of a vector of 0s and 1s into a decimal number. The
% ordering is from left to right. This is used to encode selections of
% subsets of "parents" from a ordered factorization of an entropy term,
% hence the name.
%
% Input:
%
% - sel: a binary vector
%
% Output:
%
% - p: decimal representation of "sel" shifted by 1
%
% Created by: Ricardo Silva, London, 05/05/2011
% University College London
% Current version: 05/05/2011

function p = parent_entry(sel)

p = sum(sel .* (2.^(0:(length(sel) - 1)))) + 1;
