%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% optimize_probitsem_pairwiseentropy_bound_greedy:
%
% Choose a subset of variables using a different approximation for H(Y) by
% pairwise entropies. We do it by greedy search in this case.
%
% Input:
%
% - L, S: parameters of probit model
% - sel_K_start: initialization vector
%
% Output:
%
% - sel_K: the selection of K variables
%
% Created by: Ricardo Silva, London, 22/05/2011
% University College London
% Current version: 22/05/2011

function sel_K = optimize_probitsem_pairwise_entropy_bound_greedy(L, S, sel_K_start)

% Preliminaries %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[num_y num_x] = size(L); num_x = num_x - 1;

% Calculate expectation of log terms %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

W = zeros(num_y, 1);
M = 100000;

x = chol(S)' * randn(num_x, M);

for y = 1:num_y
  m = L(y, 1:num_x) * x + L(y, end);
  py0 = normcdf(-m); py1 = 1 - py0; 
  log_py1 = log(py1); log_py1(py1 == 0) = 0;
  log_py0 = log(py0); log_py0(py0 == 0) = 0;
  W(y) = mean(py1 .* log_py1 + py0 .* log_py0);
end

clear('x');

% Get entropy terms %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf('Caching entropy information...\n');
[entropy_order cond_entropy] = optimize_pairwise_entropy_order(L, S);
entropy_sets = get_pairwise_entropy_sets(entropy_order, cond_entropy);

% Initialization %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sel_K = sel_K_start;
z = zeros(1, num_y);
z(sel_K) = 1;
not_sel_K = find(z == 0);

best_score = sum(W(sel_K)) + get_pairwise_entropy_score(z, entropy_sets);
fprintf('Initial score = %f\n', best_score);

iter = 1;
while true
  fprintf('Iteration [%d]: \n', iter);

  changed = false;
  for y1 = sel_K
    %fprintf('Attempting to remove %d\n', y1);  
    for y2 = not_sel_K     
     z(y1) = 0; z(y2) = 1;
     score = sum(W(z == 1)) + get_pairwise_entropy_score(z, entropy_sets);
     if score > best_score
       best_score = score;
       best_pair = [y1 y2];
       changed = true;
     end
     z(y1) = 1; z(y2) = 0;
    end
  end
  
  if ~changed
    break
  end
  
  z(best_pair(1)) = 1 - z(best_pair(1));
  z(best_pair(2)) = 1 - z(best_pair(2));
  sel_K = find(z == 1);
  not_sel_K = find(z == 0);

  %fprintf('Current solution [score = %f]:', best_score);
  disp(sel_K);
  iter = iter + 1;   
end
fprintf('Score found: %f\n', best_score);


