%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get_pairwise_entropy_score:
%
% Calculate a bound on the entropy of a marginal distribution using a set
% of pre-processed entropy numbers.
%
% Input:
%
% - z: a vector of binary numbers indicating which variables to keep
% - entropy_sets: data structure caching pairwise conditional entropies for 
%                 all "parents" of each variable
%
% Output:
%
% - score: the entropy bound
%
% Created by: Ricardo Silva, London, 22/05/2011
% University College London
%
% Current version: 022/05/2011

function score = get_pairwise_entropy_score(z, entropy_sets)

num_y = length(z);
score = 0;

for y = 1:num_y
  if z(y) == 0
    continue
  end
  if sum(z(entropy_sets{y}.parents)) == 0
    score = score + entropy_sets{y}.values(end);
  else
    score = score + min(entropy_sets{y}.values(z(entropy_sets{y}.parents) == 1));
  end
end
