function setup = setup_gaussian()

[setup.X setup.Y setup.noise_var] = get_synthetic_data();

setup.runs           = 10;
setup.iterations     = 5000;
setup.burn           = 1000;
setup.ess_iterations = 10;
setup.max_ls         = 10.0;
setup.min_ls         = 0.01;
setup.print_mod      = 1;

jitter    = 1e-6;
gpml_covs = {'covSum', {'covSEard', 'covNoise'}};

setup.slice_width     = 10;
setup.llh_fn          = @gaussian_llh;
setup.cov_fn          = @(theta) feval(gpml_covs{:}, [theta ; 0 ; log(jitter)], setup.X);
setup.theta_log_prior = @(theta) log(1.0*all((theta>log(setup.min_ls)) & (theta<log(setup.max_ls))));
setup.aux_noise_fn    = @aux_noise;

  function llh = gaussian_llh(ff)
    llh = -0.5*sum((ff-setup.Y).^2/setup.noise_var);
  end

  function [std gg] = aux_noise(theta, K)
    std = sqrt(setup.noise_var);
    gg  = setup.Y;
  end

end