clear;

[xx,yy] = read_forestfires();

% Best result used SVM on just (temp, RH, wind, rain):
%xx = xx([9,10,11,12], :);
% Add constant feature for bias weight to hit:
xx = [xx; ones(1, size(xx,2))];
%yy = log(1+yy);
yy = log(yy);
yy(yy==-Inf) = min(yy(yy>min(yy))) - 1; % Just for vis purposes

% Linear regression on just non-zero outputs, to get some direction for
% visualization:
idx = ~(yy==min(yy));
xx2 = xx(:,idx);
yy2 = yy(idx);
%ww = xx2'\yy2;
%ww = xx'\yy;
ww = xx'\(yy>min(yy)); % Set direction just to separate fire vs non-fire

clf;
%plot(xx2'*ww, yy2, 'x');
plot(xx'*ww, yy, 'r.');
