K = 10; % Cross-validation experiment with naive median predictor
num_runs = 30;

[xx,yy] = read_forestfires();
N = size(xx, 2);

scores = zeros(num_runs, 1);
for run = 1:num_runs
    idx = randperm(N);
    xx = xx(:, idx);
    yy = yy(idx);
    
    batches = make_batched(yy', K);
    for bb = 1:K
        pred = median(cell2mat(batches([1:bb-1,bb+1:K])));
        scores(run) = scores(run) + mean(abs(batches{bb}-pred));
    end
    scores(run) = scores(run) / K;
end

disp(errorbar_str(scores));

% >> naive_pred
% 12.8372 +/- 0.0046
%
% SVM got 12.71 +/- 0.01
%
% Cheating with naive_pred gets:
% >> mean(abs(yy-median(yy)))
% ans = 12.83
