function local_pred()

K = 10; % Cross-validation experiment with naive median predictor
num_runs = 30;

[xx,yy] = read_forestfires();
N = size(xx, 2);

scores = zeros(num_runs, 1);
for run = 1:num_runs
    idx = randperm(N);
    xx = xx(:, idx);
    yy = yy(idx);
 
    y_batches = make_batched(yy', K);
    x_batches = make_batched(xx, K);

    for bb = 1:K
        train_x = cell2mat(x_batches([1:bb-1,bb+1:K]));
        train_y = cell2mat(y_batches([1:bb-1,bb+1:K]))';
        test_x = x_batches{bb};
        test_y = y_batches{bb}';
        pred = blah(train_x, train_y, test_x);
        scores(run) = scores(run) + mean(abs(test_y-pred));
    end
    scores(run) = scores(run) / K;
end
disp(errorbar_str(scores));

% Not significantly better than naive predictor.
%
% >> naive_pred
% 12.8372 +/- 0.0046
%
% SVM got 12.71 +/- 0.01
%
% Cheating with naive_pred gets:
% >> mean(abs(yy-median(yy)))
% ans = 12.83


function pred = blah(xx, yy, test_x)

fraction_to_use = 1/6;

xx = xx([9,10,11,12], :);
xx = [xx; ones(1, size(xx,2))];
test_x = test_x([9,10,11,12], :);
test_x = [test_x; ones(1, size(test_x,2))];

%Lyy = log(1+yy);
Lyy = log(yy);

% Linear regression on just non-zero outputs, to get some direction for
% visualization:
idx = ~(yy==min(yy));
xx2 = xx(:,idx);
yy2 = Lyy(idx);
%ww = xx2'\yy2;
%ww = xx'\Lyy;
ww = xx'\(Lyy>min(Lyy)); % Set direction just to separate fire vs non-fire

test_x = (test_x'*ww)';
xx = (xx'*ww)';

M = length(test_x);
N = length(yy);
% As this doesn't make any difference, it's all bunk!
[dummy, idx] = sort(square_dist(test_x, xx), 2); % MxN
pred = zeros(M, 1);
for mm = 1:M
    pred(mm) = median(yy(idx(mm, 1:floor(N*fraction_to_use))));
end
