function gp_play()
% First stab. First classify into "fire" vs "no fire" and then regress on just
% the "fire" class. These tasks are probably related, but stuff that for now.

K = 10; % Cross-validation experiment with naive median predictor
num_runs = 30;
num_runs = 3;

[xx,yy] = read_forestfires();
N = size(xx, 2);

scores = zeros(num_runs, 1);
for run = 1:num_runs
    fprintf('Run %d / %d\n', run, num_runs);
    idx = randperm(N);
    xx = xx(:, idx);
    yy = yy(idx);
 
    y_batches = make_batched(yy', K);
    x_batches = make_batched(xx, K);

    for bb = 1:K
        fprintf('Fold %d / %d\n', bb, K);
        train_x = cell2mat(x_batches([1:bb-1,bb+1:K]));
        train_y = cell2mat(y_batches([1:bb-1,bb+1:K]))';
        test_x = x_batches{bb};
        test_y = y_batches{bb}';
        pred = blah(train_x, train_y, test_x);
        scores(run) = scores(run) + mean(abs(test_y-pred));
    end
    scores(run) = scores(run) / K;
end
fprintf('\n');
disp(errorbar_str(scores));

% >> naive_pred
% 12.8372 +/- 0.0046
%
% SVM got 12.71 +/- 0.01
%
% Without optimizing hypers I got: 12.8423 +/- 0.0072
%
% 20 steps for each hyper optimization: 12.819 +/- 0.026
%
% 3 runs with up to 100 steps: 12.814 +/- 0.015
%
% When run from gp_job with 100 steps: 12.8127 +/- 0.0041


function pred = blah(xx, yy, test_x)

use_dims = [9,10,11,12];
xx = xx(use_dims, :);
test_x = test_x(use_dims, :);

std_fn = get_standardize_fns(xx);
xx = std_fn(xx);
test_x = std_fn(test_x);

% Classification:
cc = (yy > min(yy))*2 - 1;
loghyper = [0.0; 0.0];
loghyper = minimize(loghyper, 'binaryEPGP', -100, 'covSEiso', xx', cc);
cpred = binaryEPGP(loghyper, 'covSEiso', xx', cc, test_x');

% Work out quantile of regression need to get median. If "no fire" has
% more than 0.5 probability then predict zero.
quantile = cpred - 0.5;
pred = zeros(size(test_x, 2), 1);
mask = (quantile > 0);
quantile = quantile(mask);
test_x = test_x(:, mask);

% Regression
idx = (yy > min(yy));
xx = xx(:, idx);
yy = log(yy(idx));
[std_fn, destd_fn] = get_standardize_fns(yy');
yy = std_fn(yy);
% GP regression:
covfunc = {'covSum', {'covSEiso','covNoise'}};
loghyper = [log(1.0); log(1.0); log(0.5)];
loghyper = minimize(loghyper, 'gpr', -100, covfunc, xx', yy);
[mu, S2] = gpr(loghyper, covfunc, xx', yy, test_x');
point_est = norminvcdf(quantile, sqrt(S2), mu);
% Get point_est that is required quantile through Gaussian prediction.
pred(mask) = exp(destd_fn(point_est));

