% First stab. First classify into "fire" vs "no fire" and then regress on just
% the "fire" class. These tasks are probably related, but stuff that for now.

function gp_play()

addpath('../experiment_toolbox');
name  = 'gp_play';

num_runs = 30;
success = experiment_run(name, num_runs, @one_run);

function result = one_run()

K = 10; % Cross-validation experiment with naive median predictor
[xx,yy] = read_forestfires();
N = size(xx, 2);

idx = randperm(N);
xx = xx(:, idx);
yy = yy(idx);

y_batches = make_batched(yy', K);
x_batches = make_batched(xx, K);

score = 0;
for bb = 1:K
    train_x = cell2mat(x_batches([1:bb-1,bb+1:K]));
    train_y = cell2mat(y_batches([1:bb-1,bb+1:K]))';
    test_x = x_batches{bb};
    test_y = y_batches{bb}';
    pred = blah(train_x, train_y, test_x);
    score = score + mean(abs(test_y-pred));
end
score = score / K;
result.score = score;

function pred = blah(xx, yy, test_x)

use_dims = [9,10,11,12];
xx = xx(use_dims, :);
test_x = test_x(use_dims, :);

std_fn = get_standardize_fns(xx);
xx = std_fn(xx);
test_x = std_fn(test_x);

% Classification:
cc = (yy > min(yy))*2 - 1;
loghyper = [0.0; 0.0];
loghyper = minimize(loghyper, 'binaryEPGP', -100, 'covSEiso', xx', cc);
cpred = binaryEPGP(loghyper, 'covSEiso', xx', cc, test_x');

% Work out quantile of regression need to get median. If "no fire" has
% more than 0.5 probability then predict zero.
quantile = cpred - 0.5;
pred = zeros(size(test_x, 2), 1);
mask = (quantile > 0);
quantile = quantile(mask);
test_x = test_x(:, mask);

% Regression
idx = (yy > min(yy));
xx = xx(:, idx);
yy = log(yy(idx));
[std_fn, destd_fn] = get_standardize_fns(yy');
yy = std_fn(yy);
% GP regression:
covfunc = {'covSum', {'covSEiso','covNoise'}};
loghyper = [log(1.0); log(1.0); log(0.5)];
loghyper = minimize(loghyper, 'gpr', -100, covfunc, xx', yy);
[mu, S2] = gpr(loghyper, covfunc, xx', yy, test_x');
point_est = norminvcdf(quantile, sqrt(S2), mu);
% Get point_est that is required quantile through Gaussian prediction.
pred(mask) = exp(destd_fn(point_est));

