function [std_fn, destd_fn] = get_standardize_fns(xx)
%GET_STANDARDIZE_FNS get functions useful for simple scaling of data
%
%     [std_fn, destd_fn] = get_standardize_fns(xx)
%
% Inputs:
%            xx DxN 
%
% Outputs:
%        std_fn @fn  zz = std_fn(xx) has zero mean and unit variance
%      destd_fn @fn  destd_fn(zz) == xx.

% Iain Murray, April 2010

x_sd = std(xx, [], 2);
x_mu = mean(xx, 2);
std_fn = @(z) bsxfun(@rdivide, bsxfun(@minus, z, x_mu), x_sd);
destd_fn = @(z) bsxfun(@plus, bsxfun(@times, z, x_sd), x_mu);
