% Copyright (C) 2009  Arno Onken
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

% -------------------------------------------------------------------------
% Probability mass values of an empirical distribution over integer values
% based on a sample.
%
% Arguments:
%  x      - n-by-d matrix of random samples
%
% Returns:
%  lambda - d-by-y matrix of pmf values; lambda(d, 1) is for the zero
%           values; sum (lambda(k, :)) == 1 sould hold for any k in
%           {1, ..., d}.
% -------------------------------------------------------------------------
function lambda = discempfit (x)

    % Check arguments
    if (nargin ~= 1)
        error ('discempfit: usage lambda = discempfit (x)');
    end

    x = x';

    % Dimension
    d = size (x, 1);
    m = max (max (x));
    
    % PMF matrix
    lambda = zeros (d, m + 1);
    for i = 0:m
        % Count number of samples equal to i
        lambda(:, i + 1) = sum (x == i, 2);
    end

    % Normalize sums
    lambda = lambda ./ repmat (sum (lambda, 2), 1, length (lambda));

end