function stopped = sw_play(E,x0,sim_dt,sim_factor,pause_dt)
% SW_PLAY runs the simulation
t      = 0;
set(E.Grestart,'userdata',1);
while 1
   tic;
   if isempty(findobj(0,'Tag','SwimmerWindow')) 
      stopped = 0;
      break;
   end
   if get(E.Grestart,'userdata')
      x     = x0;
      set(E.Grestart,'userdata',0);
      set(E.Gtarget,'userdata',[0; 0],'Xdata',E.tXYZ{1},'Ydata',E.tXYZ{2},'Zdata',E.tXYZ{3});
      set(E.fig,'WindowButtonMotionFcn','');
      set(E.h1,'UserData',0);      
   end
   t  = t + sim_dt*sim_factor;   
   if ~get(findobj(E.h1,'Tag','Sim'),'UserData')
      if get(E.Gtime,'Value')
         if (norm(x(E.d+(3:4))) < 0.01)  || (20*rand < sim_dt*sim_factor)
            cp = (rand(2,1)-0.5)*2*E.cScale;
            set(findobj(0,'Tag','Target'),'Xdata',E.tXYZ{1}+cp(1),'Ydata',E.tXYZ{2}+cp(2),...
               'Zdata',E.tXYZ{3},'user',cp);
         end
      end
   end         
   if get(E.Glimit,'Value')
      E.vmax = 10;
   else
      E.vmax = inf;
   end
   for subFrame = 1:sim_factor
      origin   = get(E.Gtarget,'user');  
      [x,u,w]  = integrate(E,x,origin,sim_dt);
      x_rel    = [x(1:2)-origin; x(3:end)];

      if sum(isnan(u))
         Ans = questdlg('Restart ?','Divergence !','Restart','Exit','Restart');
         if strcmp(Ans,'Restart')
            x     = x0;
            set(E.Grestart,'userdata',0);
            set(E.Gtarget,'userdata',[0; 0],'Xdata',E.tXYZ{1},'Ydata',E.tXYZ{2},'Zdata',E.tXYZ{3});
            set(E.fig,'WindowButtonMotionFcn','');
            set(E.h1,'UserData',0);
            break;
         else
            set(E.Gstop,'UserData',1);
            break
         end
      end
   end
   
   if get(E.Gstop,'UserData') 
      stopped = 1;
      break;                     
   end      
      
   if ~draw_swimmer(E,x,x_rel,w)
      stopped = 0;
      break;                     
   end
   if get(E.Grotate,'userdata')
      cam = get(E.h2,'CameraPos');
      R   = expm([0 1;-1 0]*0.01);
      set(E.h2,'CameraPos',[cam(1:2)*R cam(3)]);
   end
   drawnow;
   
   t_diff = pause_dt-toc;
   if t_diff < 0      % t_diff is the simulation time "overflow"
      disp(['lag (seconds) = ' num2str(-t_diff,'%1.3f')]);
   end
   pause(max(0,t_diff));
end

